/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.schedops;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.schedops.SchedulableDescriptor;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SchedulableConfigManager {
    private static final String CLASS_NAME = "[SchedulableConfigManager] ";
    private static final String TRACE_MASKT = "XTIMxxxT";
    private static final String TRACE_MASKF = "XTIMxxxF";
    private static final String TRACE_MASKD = "XTIMxxxD";
    private static final String FILE_PATH = "schedops";
    private static final String TAG_CONFIG = "schedulable-config";
    private static final String TAG_TARGET = "schedulable-target";
    private static final String TAG_DESCRIPTOR = "schedulable-descriptor";
    private static boolean initialized = false;
    private static Object dataLock = new Object();
    private static HashMap descriptors = new HashMap();

    private SchedulableConfigManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getSchedulableTargets() {
        Trace.trace(TRACE_MASKT, "[SchedulableConfigManager] >> getSchedulableTargets()");
        ArrayList result = new ArrayList();
        Object object = dataLock;
        synchronized (object) {
            SchedulableConfigManager.initialize();
            Iterator iterator = descriptors.keySet().iterator();
            while (iterator.hasNext()) {
                Object target = iterator.next();
                Trace.trace(TRACE_MASKF, "[SchedulableConfigManager]    Target = " + target);
                result.add(target);
            }
        }
        Trace.trace(TRACE_MASKT, "[SchedulableConfigManager] << getSchedulableTargets()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getSchedulableDescriptors(String target) {
        Trace.trace(TRACE_MASKT, "[SchedulableConfigManager] >> getSchedulableDescriptors() : " + target);
        if (target == null) {
            throw new NullPointerException("Illegal null value");
        }
        ArrayList result = new ArrayList();
        Object object = dataLock;
        synchronized (object) {
            SchedulableConfigManager.initialize();
            if (descriptors.containsKey(target)) {
                result = (ArrayList)descriptors.get(target);
            }
        }
        Trace.trace(TRACE_MASKT, "[SchedulableConfigManager] << getSchedulableDescriptors() : " + result.size());
        return (Collection)result.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        Object object = dataLock;
        synchronized (object) {
            if (!initialized) {
                try {
                    initialized = true;
                    String baseFilePath = BaseFileControl.getFilePath(FILE_PATH);
                    File[] files = new File(baseFilePath).listFiles(new FileFilter());
                    for (int i = 0; i < files.length; ++i) {
                        SchedulableConfigManager.loadConfigFile(files[i]);
                    }
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "[SchedulableConfigManager]    Exception caught!");
                    Trace.trace(TRACE_MASKF, e);
                }
            }
        }
    }

    private static void loadConfigFile(File file) {
        Trace.trace(TRACE_MASKT, "[SchedulableConfigManager] >> loadConfigFile() : " + file);
        int count = 0;
        try {
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new FileInputStream(file)));
            Document document = parser.getDocument();
            Element root = document.getDocumentElement();
            if (!root.getTagName().equals(TAG_CONFIG)) {
                throw new RuntimeException("Invalid root element : " + root);
            }
            String target = null;
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (node.getNodeName().equals(TAG_TARGET)) {
                    target = node.getFirstChild().getNodeValue().trim();
                    Trace.trace(TRACE_MASKF, "[SchedulableConfigManager]    Target = " + target);
                }
                if (!node.getNodeName().equals(TAG_DESCRIPTOR)) continue;
                String name = node.getFirstChild().getNodeValue().trim();
                Trace.trace(TRACE_MASKF, "[SchedulableConfigManager]    Schedulable = " + name);
                if (target == null || name == null) continue;
                ++count;
                SchedulableConfigManager.addDescriptor(target, (SchedulableDescriptor)Class.forName(name).newInstance());
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKT, "[SchedulableConfigManager] << loadConfigFile() : " + file + " : " + count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDescriptor(String target, SchedulableDescriptor descriptor) {
        if (target == null || descriptor == null) {
            throw new NullPointerException("Illegal null value(s)");
        }
        Object object = dataLock;
        synchronized (object) {
            if (descriptors.containsKey(target)) {
                ((ArrayList)descriptors.get(target)).add(descriptor);
            } else {
                ArrayList<SchedulableDescriptor> values = new ArrayList<SchedulableDescriptor>();
                values.add(descriptor);
                descriptors.put(target, values);
            }
        }
    }

    private static class FileFilter
    implements FilenameFilter {
        private FileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".xml");
        }
    }
}

